#!/bin/env bash

LOG_FILE="/var/log/monitoring-test.log"
PROCESS_NAME="test"
API_URL="https://test.com/monitoring/test/api"
PID_FILE="/tmp/.pid"

log_message() {
    echo "$(date '+%c') - $1" >> "$LOG_FILE"
}

check_process() {
    if pgrep -x "$PROCESS_NAME" > /dev/null; then
        return 0
    else
        return 1
    fi
}

check_restart() {
    local current_pid=$(pgrep -x "$PROCESS_NAME" | head -n1)

    if [ -f "$PID_FILE" ]; then
        local old_pid=$(cat "$PID_FILE")
        if [ "$old_pid" != "$current_pid" ] && [ -n "$current_pid" ]; then
            echo "$current_pid" > "$PID_FILE"
            log_message "Restarted, new PID $current_pid, old PID $old_pid"
            return 0
        fi
    else
        if [ -n "$current_pid" ]; then
            echo "$current_pid" > "$PID_FILE"
        fi
    fi

    return 1
}

call_api() {
    if curl -s -o /dev/null -w "%{http_code}" --max-time 10 "$API_URL" | grep -q "200"; then
        log_message "Success: $API_URL"
        return 0
    else
        log_message "Error: $API_URL"
        return 1
    fi
}

if check_process; then
    if check_restart; then
        log_message "Warning: process $PROCESS_NAME restarted"
    fi
    call_api
else
    log_message "Error: $PROCESS_NAME not found"
fi
